#ifndef __L4_RMGR_H
#define __L4_RMGR_H

#include <l4/sys/compiler.h>
#include <l4/sys/types.h>
#include <l4/sys/l4int.h>

extern int have_rmgr;
extern l4_threadid_t rmgr_id;
extern l4_threadid_t rmgr_pager_id;

EXTERN_C_BEGIN

int rmgr_init(void);

int rmgr_set_small_space(l4_threadid_t dest, int num);

/*!\brief Set the priority of a thread
 *
 * \retval 0		Ok, prio was set
 * \retval -1		some error: thread does not exist or mcp of caller
 *			is below old or new prio of dest. Or prio support
 *			is disabled in librmgr.
 * \retval 16		L4_IPC_ENOT_EXISTENT: IPC error.
 *			Probably rmgr_init() was not called.
 */
int rmgr_set_prio(l4_threadid_t dest, int num);
int rmgr_get_prio(l4_threadid_t dest, int *num);

int rmgr_get_task(int num);
int rmgr_free_task(int num);
int rmgr_free_task_all(l4_threadid_t client);

int rmgr_get_irq(int num);
int rmgr_free_irq(int num);
int rmgr_free_irq_all(l4_threadid_t client);

int rmgr_dump_mem(void);
int rmgr_get_page0(void *address);

int rmgr_get_task_id(const char *module_name, l4_threadid_t *thread_id);

l4_taskid_t rmgr_task_new(l4_taskid_t dest, l4_umword_t mcp_or_new_chief,
			  l4_umword_t esp, l4_umword_t eip,
			  l4_threadid_t pager);

l4_taskid_t rmgr_task_new_with_prio(l4_taskid_t dest,
				    l4_umword_t mcp_or_new_chief,
				    l4_umword_t esp, l4_umword_t eip,
				    l4_threadid_t pager,
				    l4_sched_param_t sched_param);

int rmgr_set_task_id(const char *module_name, l4_threadid_t thread_id);

int rmgr_free_fpage(l4_fpage_t fp);
int rmgr_free_page(l4_umword_t address);
int rmgr_free_mem_all(l4_threadid_t client);

l4_umword_t rmgr_reserve_mem(l4_umword_t size, l4_umword_t align,
			     l4_umword_t flags, l4_umword_t range_low,
			     l4_umword_t range_high);

int rmgr_privctrl(l4_umword_t cmd, l4_umword_t param);

EXTERN_C_END

#endif /* ! __L4_RMGR_H */
