#include "local.h"

// evil: call configure() with invalid channel number. this
//       will only change the debug state
void l4ore_debug(int flag)
{
  DICE_DECLARE_ENV(env);
  l4ore_handle_t handle = L4_INVALID_ID;
  l4ore_config conf;
  env.malloc = (dice_malloc_func)malloc;
  env.free   = (dice_free_func)free;
  conf.rw_debug = flag;

  if (ore_lookup_server())
    return;

  ore_manager_configure_call(&ore_server, &handle, &conf, &conf, &env);
}

l4ore_config l4ore_get_config(int channel)
{
  DICE_DECLARE_ENV(env);
  l4ore_config conf;
  l4ore_config inval = L4ORE_INVALID_CONFIG;
  l4ore_handle_t handle = descriptor_table[channel].remote_worker_thread;
  env.malloc = (dice_malloc_func)malloc;
  env.free   = (dice_free_func)free;

  if (l4_thread_equal(ore_server, L4_INVALID_ID))
    return L4ORE_INVALID_CONFIG;

  
  ore_manager_configure_call(&ore_server, &handle, &inval, &conf, &env);

  return conf;
}

void l4ore_set_config(int channel, l4ore_config *new_conf)
{
  DICE_DECLARE_ENV(env);
  l4ore_config old;
  l4ore_handle_t handle = descriptor_table[channel].remote_worker_thread;
  env.malloc = (dice_malloc_func)malloc;
  env.free   = (dice_free_func)free;
 
  if (new_conf == NULL)
      return;

  ore_manager_configure_call(&ore_server, &handle, new_conf, &old, &env);
}

