
#include "config_gdt.h"
#include "config_tcbsize.h"
#include "globalconfig.h"
#include "idt_init.h"
#include "low_level.h"
#include "shortcut.h"
#include "tcboffset.h"
#include "regdefs.h"
#include "asm.h"

#define L4_IPC_RECANCELED		0x40
#define L4_IPC_RETIMEOUT		0x20

#define	PDIR_IDX(virt)			(((virt) >> 22) & 0x3ff)


#define OFS__THREAD__SS   (THREAD_BLOCK_SIZE - 1*8)
#define OFS__THREAD__ESP  (THREAD_BLOCK_SIZE - 2*8)
#define OFS__THREAD__EFL  (THREAD_BLOCK_SIZE - 3*8)
#define OFS__THREAD__CS   (THREAD_BLOCK_SIZE - 4*8)
#define OFS__THREAD__EIP  (THREAD_BLOCK_SIZE - 5*8)

// In the SYSENTER path all kernel memory accesses go through stack
// segment ss. This way we do not need to RESET_KERNEL_SEGMENTS in
// SMAS. The RESET_KERNEL_SEGMENTS function is executed if the shortcut
// fails or we switch to another thread which is not in shortcut.

	//
	// ready_enqueue
	//
	// Here we don't check if the context which is to be enqueued is
	// not current() and has the same priority as current(). In this
	// case, Context::ready_enqueue() enqueues current() first. We
	// don't do this here but the location this macro is called from
	// has to check this.
	//
	// precondition  : ecx = thread->sched()
	//		   eax = thread->sched()->prio()
	// scratches     : ecx, edx
	.macro	READY_ENQUEUE thread, label, kseg
	// if (prio > prio_highest)
	//   prio_highest = prio
	cmp	\kseg CONTEXT_PRIO_HIGHEST, %rax
	jbe	1f
	mov	%rax, \kseg CONTEXT_PRIO_HIGHEST

	mov    \kseg CONTEXT_PRIO_NEXT (, %rax, 4), %rdx
	// if (!prio_next[prio])
	or	%rdx, %rdx
	jnz	2f
	// prio_next[prio] = this;
	mov    \thread, \kseg CONTEXT_PRIO_NEXT (, %rax, 4)
	// ready_next = this;
	mov	\thread, \kseg OFS__THREAD__READY_NEXT (\thread)
	// ready_prev = this;
	mov	\thread, \kseg OFS__THREAD__READY_PREV (\thread)
	jmp	\label
2:	// ecx = prio_next[prio]->ready_prev
	mov    \kseg OFS__THREAD__READY_PREV (%rdx), %rcx
	// ready_next = prio_next[prio]
        mov    %rdx, \kseg OFS__THREAD__READY_NEXT (\thread)
	// ready_prev = prio_next[prio]->ready_prev
        mov    %rcx, \kseg OFS__THREAD__READY_PREV (\thread)
	// prio_next[prio]->ready_prev = this
	mov	\thread, \kseg OFS__THREAD__READY_PREV (%rdx)
	// ready_prev->ready_next = this
	mov	\thread, \kseg OFS__THREAD__READY_NEXT (%rcx)
	.endm


# define KIP_SWITCH_TIME   0xA8
# define KIP_CONSUMED_TIME 0xB8

	//
	// bookkeeping for the time a thread consumed
	//
	// precondition  : ebx = THIS
	//                 esi = DEST
	// scratches     : eax, ecx, edx, ebp
	.macro	CONSUME_TIME kseg
	.endm


#ifdef CONFIG_ASSEMBLER_IPC_SHORTCUT

	// ipc entry point for int 0x30
	.align	16
	.globl	entry_sys_ipc
entry_sys_ipc:
#define	RECV_DESC_ebp %rbp

	push	%rax
	SAVE_STATE
#define REGS_esp %rsp

	ESP_TO_TCB_AT %rbx
#define THIS_ebx %rbx
	
	RESET_THREAD_CANCEL_AT THIS_ebx

	// test if long send or no send at all
	test	$~0, %rax
	jnz	i30_shortcut_failed

	// we need it later
	mov	REG_ECX (REGS_esp), %rcx

	// test if destination is L4_INVALID_ID
	cmp	$0xffffffffffffffff, %rsi
	je	i30_shortcut_failed

	// test if destination is L4_NIL_ID
	or	%rsi, %rsi
	jz	i30_shortcut_failed

	// test if destination has ''next_period'' bit set
	test	$0x00200000, %rdi
	jnz	i30_shortcut_failed

	// test if have receive operation
	cmp	$0xffffffffffffffff, RECV_DESC_ebp
	je	i30_test_tcb_mapped			// no

	// test if short receive
	cmp	$1, RECV_DESC_ebp
	ja	i30_shortcut_failed			// more than 2 dwords
	
	// test if simple timeout
	mov	%rcx, %rdi
	and	$0x0f, %rdi
	jz	1f				// rcv_to==inf => o.k.
	shr	$24, %rcx
	jnz	i30_shortcut_failed		// (rcv_to!=inf) && (rcv_to!=0)

1:	// test if open wait and (irq attached or sender queued)
	// ebp is 0 (receive) or 1 (open wait) here
	test	RECV_DESC_ebp, RECV_DESC_ebp
	jz	i30_test_tcb_mapped
	
	mov	OFS__THREAD__SENDER_FIRST (THIS_ebx), %rax
	test	%rax, %rax
	jnz	i30_shortcut_failed
	or	OFS__THREAD__IRQ (THIS_ebx), %rax
	jnz	i30_shortcut_failed
	jmp	i30_test_tcb_mapped

i30_shortcut_failed:
	// shortcut failed, execute normal ipc C++ - pass
	CNT_SHORTCUT_FAILED
	call	sys_ipc_wrapper
in_slow_ipc1:
        CHECK_SANITY $3                         // scratches ecx
        RESET_USER_SEGMENTS $3,in_cli           // scratches ecx
	RESTORE_STATE_AFTER_IPC
	pop	%rax
	iretq

	.align	8
i30_test_tcb_mapped:
	add	%rsi, %rsi
	and	$TCB_ADDRESS_MASK, %rsi
	add	%rsi, %rsi
	or	$VAL__MEM_LAYOUT__TCBS, %rsi	// dst = dst_id.lookup

#define DEST_esi %rsi
	
	lea	OFS__THREAD__STATE (DEST_esi), %rcx // addr of dst tcb state

	// Here we could raise a pagefault. The pagefault handler notices
	// that by looking at the pagefault address. In that case the pager
	// sets the carry flag to 1 and returns immediatly.
	// The idea behind this, is to enable interrupts early as
	// possible. The update of the pagedirectory in the pagefault
	// handler are too expensive for cli mode.
	// So the pagefault handler will enable interrupts.

	and	$0xffffffffffffffff, %ss:(%rcx)	// can raise pagefault
	jc	i30_shortcut_failed_1		// tcb is not paged

	testq	$(Thread_delayed_deadline | Thread_delayed_ipc), (%rcx)
	jnz	i30_shortcut_failed_1

	mov	(%rcx), %rax

	and	$(Thread_receiving | Thread_send_in_progress | \
		Thread_ipc_in_progress), %rax

	mov	OFS__THREAD__PARTNER (DEST_esi), %rdx

	// dst->tread_lock()->test()
	cmp	$0, OFS__THREAD__THREAD_LOCK__SWITCH_LOCK__LOCK_OWNER (DEST_esi)
	jne	i30_shortcut_failed_1			// dst is locked

	lea	CAST__Thread_TO_Sender (THIS_ebx), %rcx // (Sender*)this

	//    (ipc_state == (Thread_receiving | Thread_ipc_in_progress)
	cmpb	$(Thread_ipc_in_progress | Thread_receiving), %al
	jne	i30_shortcut_failed_1

	// see Receiver::sender_ok
//	movl    OFS__THREAD__SENDER_FIRST (DEST_esi), %eax

	// if DEST_esi->partner() == 0, openwait
	test	%rdx, %rdx
	jne	1f

	// sender_queue empty?
//	testl	%eax, %eax
//	jnz	1f
	jmp	i30_sender_ok
1:
	// if DEST_esi->partner() == this, wait for me
	cmp	%rcx, %rdx
	jne	i30_shortcut_failed_1
	jmp	i30_sender_ok

i30_shortcut_failed_1:
	// shortcut failed, execute normal ipc C++ - pass
	jmp	i30_shortcut_failed

i30_sender_ok:
	CNT_SHORTCUT_SUCCESS

	// copy the short msg directly into the registers of the receiver
	mov	OFS__THREAD__RCV_REGS (DEST_esi), %rax
	mov	REG_EDX (REGS_esp), %rdx
	mov	REG_EBX (REGS_esp), %rcx
	mov	%edx, REG_EDX (%rax)		// dst_regs->edx = edx
	mov	%ecx, REG_EBX (%rax)		// dst_regs->ebx = ebx
	movq	$RETURN_DOPE, REG_EAX (%rax)	// dst_regs->eax = DOPE(3,0)
	mov	OFS__THREAD__ID (THIS_ebx), %rdx
	mov	OFS__THREAD__ID+4 (THIS_ebx), %rcx
	mov	%edx, REG_ESI (%rax)		// dst_regs->esi = id.low
	mov	%ecx, REG_EDI (%rax)		// dst_regs->edi = id.high

	// wake up receiver
	andq	$~(Thread_ipc_receiving_mask | \
		   Thread_ipc_in_progress | Thread_lipc_ready),\
		OFS__THREAD__STATE (DEST_esi)
	orb	$Thread_ready, OFS__THREAD__STATE (DEST_esi)

	// default: no receive part => status ok
	xor	%rax, %rax

	// prepare a receive if we have one
	cmp	$0xffffffffffffffff, RECV_DESC_ebp
	je	i30_do_switch_exec			// no receive part

	// set_rcv_regs (regs)
	mov	REGS_esp, OFS__THREAD__RCV_REGS (THIS_ebx)

        orb	$(Thread_receiving | Thread_ipc_in_progress),\
		OFS__THREAD__STATE (THIS_ebx)

        // default: open wait
	xor	%rcx, %rcx
	
        test   RECV_DESC_ebp, RECV_DESC_ebp      // open wait?
	jnz	1f				// openwait cmp yes

        // set dst's partner
        lea     CAST__Thread_TO_Sender (DEST_esi), %rcx // (Sender*)dst

1:	mov	%rcx, OFS__THREAD__PARTNER (THIS_ebx)

	// timeout = 0
	movb	$L4_IPC_RETIMEOUT, %al
	test	%rdi, %rdi			// edi==0: timout==inf
	jne	i30_do_switch_exec		// timeout==inf? no

	// timeout = infinite ==> need wakeup
	movb	$L4_IPC_RECANCELED, %al
	andb	$~Thread_ready, OFS__THREAD__STATE (THIS_ebx)

	.align	8
i30_do_switch_exec:

	mov	%rax, REG_EAX (REGS_esp)	// store ipc result

	CNT_CONTEXT_SWITCH

	mov	OFS__THREAD__STATE (THIS_ebx), %rax

#ifndef CONFIG_PF_UX
	test	$Thread_fpu_owner, %rax
	jz	1f
	// set ts
	mov	%cr0, %rdx
	or	$CR0_TS, %rdx
	mov	%rdx, %cr0
        jmp	2f

1:	testq	$Thread_fpu_owner, OFS__THREAD__STATE (DEST_esi)
	jz	2f
	// clear ts
	clts	
2:
#endif	// CONFIG_PF_UX

	xor	%rdx, %rdx
	
	// if ((state() & Thread_ready) && ! in_ready_list())
	//   ready_enqueue()
	cmp	%rdx, OFS__THREAD__READY_NEXT (THIS_ebx)
	jne	i30_no_enqueue
	testb	$Thread_ready, %al
	jnz	i30_enqueue_this

i30_no_enqueue:
	// not for performance kernels!
	CONSUME_TIME 0+				// scratches eax, ecx, edx, ebp

	// push restart address onto old stack
	push	$i30_ret_switch
	
	// context switch
	mov	%rsp, OFS__THREAD__KERNEL_SP (THIS_ebx)
	mov	OFS__THREAD__KERNEL_SP (DEST_esi), %rsp

	// we don't need to test for dst->kernel_sp==0 here because this
	// case is only relevant for two cases:
	// - if the thread is about to be created, the thread state is
	//   invalid until Thread::initialize()
	// - if the thread is about to be destroyed, the thread is locked
	//   and therefore we don't take the shortcut

	mov	DEST_esi, THIS_ebx
#undef DEST_esi

	// *(kmem::kernel_esp()) = reinterpret_cast<Address>(regs() + 1);
	mov	CPU_TSS, %rax
	lea	THREAD_BLOCK_SIZE (THIS_ebx), %rcx
	mov	%rcx, 4 (%rax)  // x86_tss.esp0

	// eax = this->space_context()
	mov	OFS__THREAD__SPACE_CONTEXT (THIS_ebx), %rax

#ifdef CONFIG_PF_PC
	// test if IPC window is not empty
	lea	PDIR_IDX(VAL__MEM_LAYOUT__IPC_WINDOW0) << 2 (%rax), %rdi

	// pdir = space_context - kmem::mem_phys (needed later)
	sub	PHYSMEM_OFFS, %rax

	// _dir[index] || _dir[index+1] || _dir[index+2] || _dir[index+3]
	mov	(%rdi), %rcx
	or	4 (%rdi), %rcx
	or	8 (%rdi), %rcx
	or	12 (%rdi), %rcx
	jne	i30_flush_ipcwin_and_pdir	// yes => flush whole TLB
#else
	// pdir = space_context - kmem::mem_phys (needed later)
	sub	PHYSMEM_OFFS, %rax
#endif

	// eax = page table register of new big Space_context

	mov	PAGE_DIR_ADDR, %rcx		// Space_context::current
	cmp	%rax, %rcx			// == the new Space_context?
	jne	i30_flush_pdir			// no => flush

i30_jump_to_thread:
	pop	%rax
	jmp	*%rax

#ifndef CONFIG_PF_UX
i30_flush_ipcwin_and_pdir:
	xor	%rcx, %rcx
	mov	%rcx, (%rdi)
	mov	%rcx, 4(%rdi)
	mov	%rcx, 8(%rdi)
	mov	%rcx, 12(%rdi)
#endif

i30_flush_pdir:
	CNT_ADDR_SPACE_SWITCH
	mov	%rax, PAGE_DIR_ADDR
	pop	%rax
	jmp	*%rax

i30_ret_switch:
	ESP_TO_TCB_AT %rbx
	RESET_THREAD_IPC_MASK_AT %rbx
	CHECK_SANITY $3				// scratches ecx
	RESET_USER_SEGMENTS $3,in_cli		// scratches ecx
	RESTORE_STATE_AFTER_IPC
	pop	%rax
	iretq

i30_enqueue_this:
//#define THIS_ebx %rbx
	// ecx = sched(), eax = sched()->prio()
	mov	OFS__THREAD__SCHED (THIS_ebx), %rcx
	movl	OFS__SCHED_CONTEXT__PRIO (%rcx), %eax
	READY_ENQUEUE THIS_ebx, i30_no_enqueue, 0+	// scratches ecx, edx
	jmp	i30_no_enqueue



#ifndef CONFIG_PF_UX

// IPC entry point for sysenter. 

	.align	16
	.globl	entry_sys_fast_ipc
entry_sys_fast_ipc:
	pop	%rsp
	sub	$48, %rsp
	movq	$(GDT_DATA_USER|SEL_PL_U), REG_SS (%rsp)

	// Fake user eflags, set IOPL to 3
	movq	$EFLAGS_IOPL_U, REG_EFL (%rsp)
	// Fake user cs. This cs value is never used with exception
	// that the thread is ex_regs'd before we leave with sysexit.
	// lthread_ex_regs has to check user cs for that value. If
	// it is faked, the thread would leave the kernel by sysexit
	// and the thread is in the slow ipc path. Sysexit would
	// adapt the user eip (by subtracting 2) to ensure the user
	// executes the "mov %ebp,%edx" sequence. This is wrong if
	// the thread is ex_regs'd. In that case, we modify the return
	// value from "call dispatch_syscall" to an alternate exit
	// path using "iret".
	movq	$(GDT_CODE_USER|SEL_PL_U|0x80), REG_CS (%rsp)
	mov	%rbx, REG_EBX (%rsp)
	mov	(%rcx), %rbx
	mov	%rax, REG_EAX (%rsp)
	mov	%rbx, REG_EIP (%rsp)
	mov	%rbp, REG_EBP (%rsp)
	mov	%rdi, REG_EDI (%rsp)
	mov	12(%rcx), %rbx
	mov	%rsi, REG_ESI (%rsp)
	mov	%rdx, REG_EDX (%rsp)
	mov	%rbx, REG_ECX (%rsp)

	ESP_TO_TCB_AT %rbx
#define THIS_ebx %rbx
#define	RECV_DESC_ebp	%rbp
#define REGS_esp	%rsp
#define DWORD1_edx	%rdx

	lea	16(%rcx), %rcx			// adapt user esp

	RESET_THREAD_CANCEL_AT THIS_ebx

	mov	%rcx, REG_ESP (%rsp)		// set user esp

	// test if long send or no send at all
	test	$~0, %rax
	jnz	se_shortcut_failed

	// we need it later
	mov	REG_ECX (REGS_esp), %rcx

	// test if destination is L4_INVALID_ID
	cmp	$0xffffffffffffffff, %rsi
	je	se_shortcut_failed

	// test if destination is L4_NIL_ID
	test	%rsi, %rsi
	jz	se_shortcut_failed
	// test if destination has ``next_period'' bit set
	test	$0x00200000, %rdi
	jnz	se_shortcut_failed

	lea	(%rsi, %rsi), %rsi
	and	$TCB_ADDRESS_MASK, %rsi
	or	$VAL__MEM_LAYOUT__TCBS, %rsi	// dst = dst_id.lookup
#define DEST_esi %rsi

	// test if have receive operation
	cmp	$0xffffffffffffffff, RECV_DESC_ebp
	je	se_test_tcb_mapped		// no

	// test if short receive
	cmp	$1, RECV_DESC_ebp
	ja	se_shortcut_failed		// more than 2 dwords
	
	// test if simple timeout
	mov	%rcx, %rdi			// rcv_to==inf => edi=0
	and	$0x0f, %rdi
	jz	1f				// rcv_to==inf => o.k.
	testl	$0xff000000, %rcx
	jnz	se_shortcut_failed		// (rcv_to!=inf) && (rcv_to!=0)

1:	// test if open wait and (irq attached or sender queued)
	// ebp is 0 (receive) or 1 (open wait) here
	test	RECV_DESC_ebp, RECV_DESC_ebp
	jz	se_test_tcb_mapped		// closed wait

	mov	KSEG OFS__THREAD__SENDER_FIRST (THIS_ebx), %rax
	test	%rax, %rax
	jnz	se_shortcut_failed
	or	KSEG OFS__THREAD__IRQ (THIS_ebx), %rax
	jnz	se_shortcut_failed
	jmp	se_test_tcb_mapped

	.align	8
se_shortcut_failed:
	// shortcut failed, execute normal ipc C++ pass
	CNT_SHORTCUT_FAILED
	call	sys_ipc_wrapper
in_slow_ipc2:

	DO_SYSEXIT

//	.align	16
se_test_tcb_mapped:
	lea	OFS__THREAD__STATE (DEST_esi), %rcx // addr of dst tcb state

	// Here we could raise a pagefault. The pagefault handler notices
	// that by looking at the pagefault address. In that case the pager
	// sets the carry flag and returns immediatly.
	and	$0xffffffffffffffff, %ss:(%rcx)		// can raise pagefault
	jc	se_shortcut_failed_1		// tcb is not paged

	testq	$(Thread_delayed_deadline | Thread_delayed_ipc), KSEG (%rcx)
	jnz	se_shortcut_failed_1

	mov	KSEG (%rcx), %rax

	and	$(Thread_receiving | Thread_send_in_progress | \
		Thread_ipc_in_progress), %rax

	mov	KSEG OFS__THREAD__PARTNER (DEST_esi), %rdx
	
	// dst->thread_lock()->test()
	cmp	$0, \
		KSEG OFS__THREAD__THREAD_LOCK__SWITCH_LOCK__LOCK_OWNER (DEST_esi)
	jne	se_shortcut_failed_1		// dst is locked

	lea	CAST__Thread_TO_Sender (THIS_ebx), %rcx // (Sender*)this

	//    (ipc_state == (Thread_receiving | Thread_ipc_in_progress)
	cmpb	$(Thread_ipc_in_progress | Thread_receiving), %al
	jne	se_shortcut_failed_1

	// see Receiver::sender_ok
//	movl    KSEG OFS__THREAD__SENDER_FIRST (DEST_esi), %eax

	// if DEST_esi->partner() == 0, openwait
	test	%rdx, %rdx
	jne	1f

	// sender_queue empty?
//	testl	%eax, %eax
//	jnz	1f
	jmp	se_sender_ok

1:	// if DEST_esi->partner() == this, wait for me
	cmp	%rcx, %rdx
	jne	se_shortcut_failed_1
	jmp	se_sender_ok

se_shortcut_failed_1:
	jmp	se_shortcut_failed


	.align	16
se_sender_ok:
	CNT_SHORTCUT_SUCCESS

	// clear, we need it later
	xor	%rax, %rax

	// wake up receiver
	andq	$~(Thread_ipc_receiving_mask | \
		   Thread_ipc_in_progress), KSEG OFS__THREAD__STATE (DEST_esi)
	orb	$Thread_ready, KSEG OFS__THREAD__STATE (DEST_esi)

	// %eax=0 => default: no receive part => status ok

	// prepare a receive if we have one
	cmp	$0xffffffffffffffff, RECV_DESC_ebp
	je	se_do_switch_exec		// no receive part

	// set_rcv_regs (regs)
	mov	REGS_esp, KSEG OFS__THREAD__RCV_REGS (THIS_ebx)

        orb	$(Thread_receiving | Thread_ipc_in_progress),\
		 KSEG OFS__THREAD__STATE (THIS_ebx)

        // default: open wait
	xor	%rcx, %rcx

        test    RECV_DESC_ebp, RECV_DESC_ebp    // open wait?
	jnz	1f				// openwait cmp yes

        // set dst's partner
	lea	CAST__Thread_TO_Sender (DEST_esi), %rcx // (Sender*)dst

1:	mov	%rcx, KSEG OFS__THREAD__PARTNER (THIS_ebx)

	// timeout = 0
	movb	$L4_IPC_RETIMEOUT, %al
	test	%rdi, %rdi			// edi==0: timout==inf
	jne	se_do_switch_exec		// timeout==inf? no

	// timeout = infinite ==> need wakeup
	movb	$L4_IPC_RECANCELED, %al
	andb	$~Thread_ready, KSEG OFS__THREAD__STATE (THIS_ebx)

	.align	8
se_do_switch_exec:

	mov	%rax, REG_EAX (REGS_esp)	// store ipc result

	CNT_CONTEXT_SWITCH

        mov     KSEG OFS__THREAD__STATE (THIS_ebx), %rax
	testq	$Thread_fpu_owner, %rax
	jz	1f
	// set ts
	mov	%cr0, %rdx
	or	$CR0_TS, %rdx
	mov	%rdx, %cr0   
	jmp	2f

1:	testq	$Thread_fpu_owner, KSEG OFS__THREAD__STATE (DEST_esi)
	jz	2f
	// clear ts
	clts       

2:	// %eax=thread_state (THIS_ebx)
	xor	%rdx, %rdx

	// if (state() & Thread_ready && ! in_ready_list())
	//   ready_enqueue()
	cmp	%rdx, KSEG OFS__THREAD__READY_NEXT (THIS_ebx)
	jne	se_no_enqueue
	testb	$Thread_ready, %al
	jnz	se_enqueue_this

	.align	8
se_no_enqueue:
	// not for performance kernels!
	CONSUME_TIME KSEG 0+			// scratches eax, ecx, edx, ebp

	// push restart address onto old stack
	push	$se_ret_switch
	mov	%rsp, KSEG OFS__THREAD__KERNEL_SP (THIS_ebx)
#undef REGS_esp
	mov	KSEG OFS__THREAD__KERNEL_SP (DEST_esi), %rbp

	// we don't need to test for dst->kernel_sp==0 here because this
	// case is only relevant for two cases:
	// - if the thread is about to be created, the thread state is
	//   invalid until Thread::initialize()
	// - if the thread is about to be destroyed, the thread is locked
	//   and therefore we don't take the shortcut

	// switch esp0 on TSS
	mov	KSEG CPU_TSS, %rax
	leaq	THREAD_BLOCK_SIZE (DEST_esi), %rcx
	mov	%rcx, KSEG 4 (%rax)	// x86_tss.esp0

	mov	KSEG OFS__THREAD__SPACE_CONTEXT (DEST_esi), %rax

	// edi = index = _dir.virt_to_idx(Mem_layout::Ipc_window(0))
	lea	PDIR_IDX(VAL__MEM_LAYOUT__IPC_WINDOW0) << 2 (%rax), %rdi

	// pdir = space_context - kmem::mem_phys (needed later)
	sub	KSEG PHYSMEM_OFFS, %rax

	// _dir[index] || _dir[index+1] || _dir[index+2] || _dir[index+3]?
	mov	KSEG (%rdi), %rcx
	or	KSEG 4(%rdi), %rcx
	or	KSEG 8(%rdi), %rcx
	or	KSEG 12(%rdi), %rcx
	jne	se_flush_ipcwin_and_pdir	// yes => flush

	mov	PAGE_DIR_ADDR, %rcx		// get_pdir()
	cmp	%rax, %rcx			// get_pdir == pdir
	jne	se_flush_pdir			// no => flush

se_addr_space_switched:	
	cmpq	$se_ret_switch, (%rbp)
	jne	se_slow_switch

	RESET_THREAD_IPC_MASK_AT DEST_esi

	// Setup return registers. We have to add 4 to each %esp reference
	// since there is the return address pushed on the stack.

#if !defined(CONFIG_SMALL_SPACES)
	mov	KSEG OFS__THREAD__EIP (DEST_esi), %rdx
	sub	$2, %rdx
	mov	KSEG OFS__THREAD__ESP (DEST_esi), %rcx
	mov	KSEG OFS__THREAD__ID  (THIS_ebx), %rsi
	mov	KSEG OFS__THREAD__ID+4 (THIS_ebx), %rdi
	mov	4+REG_EBX (%rsp), %rbx
	mov	4+REG_EDX (%rsp), %rbp
	mov	$RETURN_DOPE, %rax
	sti
	sysexit
#endif


se_flush_ipcwin_and_pdir:
	xor	%rcx, %rcx
	mov	%rcx, KSEG (%rdi)			// _dir[index  ] = 0
	mov	%rcx, KSEG 4(%rdi)			// _dir[index+1] = 0
	mov	%rcx, KSEG 8(%rdi)			// _dir[index+2] = 0
	mov	%rcx, KSEG 12(%rdi)			// _dir[index+3] = 0

se_flush_pdir:
	CNT_ADDR_SPACE_SWITCH
	mov	%rax, PAGE_DIR_ADDR			// set pdir, flush TLBs
	jmp	se_addr_space_switched

se_enqueue_this:
	// ecx = sched(), eax = sched()->prio()
	mov	KSEG OFS__THREAD__SCHED (THIS_ebx), %rcx
	movl	KSEG OFS__SCHED_CONTEXT__PRIO (%rcx), %eax
	READY_ENQUEUE THIS_ebx, se_no_enqueue, KSEG 0+ // scratches ecx, edx
	jmp	se_no_enqueue

	.align	16
se_ret_switch:
	// shortcut success
	ESP_TO_TCB_AT %rbx
	RESET_THREAD_IPC_MASK_AT %rbx
	DO_SYSEXIT

	// The destination thread is not in a shortcut IPC so we cannot
	// throw it directly into user space since it may held a thread
	// lock or does not return via sysexit (int-entered IPC or
	// ex_regs manipulation)
	.align	16
se_slow_switch:
	mov	KSEG OFS__THREAD__RCV_REGS (DEST_esi), %rax
	mov	4+REG_EDX (%rsp), %rdx
	mov	4+REG_EBX (%rsp), %rcx
	mov	%rdx, KSEG REG_EDX (%rax)		// dst_regs->edx = dw1
	mov	%rcx, KSEG REG_EBX (%rax)		// dst_regs->ebx = dw2
	mov	KSEG OFS__THREAD__ID (THIS_ebx), %rdx
	mov	KSEG OFS__THREAD__ID+4 (THIS_ebx), %rcx
	movq	$RETURN_DOPE, KSEG REG_EAX (%rax)
	mov	%rdx, KSEG REG_ESI (%rax)	    // dst_regs->esi = id.low
	mov	%rcx, KSEG REG_EDI (%rax)	    // dst_regs->edi = id.high
	RESET_KERNEL_SEGMENTS
	mov	%rbp, %rsp			    // load new stack pointer
	pop	%rax
	jmp	*%rax

	.globl	in_slow_ipc2
	.globl	se_ret_switch

#endif // CONFIG_PF_UX

	.globl	in_slow_ipc1
	.globl	i30_ret_switch

#endif // CONFIG_ASSEMBLER_IPC_SHORTCUT

	// fast return from Dirq::hit
	.align	16
	.globl	fast_ret_from_irq
fast_ret_from_irq:
	CHECK_SANITY $3				// scratches ecx
	RESTORE_STATE
	pop	%rax
	and	$0x7f, 16(%rsp)			// if entered using syscall
	orq	$EFLAGS_IF, 24(%rsp)		// if entered using syscall
	iretq

