IMPLEMENTATION[arm]:

#include "types.h"
#include "std_macros.h"

PUBLIC static inline
Mword Proc::stack_pointer()
{
  Mword sp;
  asm volatile ( "mov %0, sp \n" : "=r"(sp) );
  return sp;
}

IMPLEMENT static inline
void Proc::stack_pointer(Mword sp)
{
  asm volatile ( "mov sp, %0 \n" : : "r"(sp) );
}

IMPLEMENT static inline
Mword Proc::program_counter()
{
  register Mword pc asm ("pc");
  return pc;
}

IMPLEMENT static inline
void Proc::cli()
{
  asm volatile ( "    mrs    r6, cpsr    \n"
		 "    orr    r6,r6,#128  \n"
		 "    msr    cpsr_c, r6  \n"
		 : : : "r6", "memory"
		 );
}

IMPLEMENT static inline
void Proc::sti()
{
  asm volatile ( "    mrs    r6, cpsr    \n"
                 "    bic    r6,r6,#128  \n"
		 "    msr    cpsr_c, r6  \n"
		 : : : "r6", "memory"
		 );
}

IMPLEMENT static inline
Proc::Status Proc::cli_save()
{
  Status ret;
  asm volatile ( "    mrs    r6, cpsr    \n"
		 "    mov    %0, r6      \n"
		 "    orr    r6,r6,#128  \n"
		 "    msr    cpsr_c, r6  \n"
		 : "=r"(ret) : : "r6" 
		 );
  return ret;
}

IMPLEMENT static inline
Proc::Status Proc::interrupts()
{
  Status ret;
  asm volatile ("   mrs  %0, cpsr  \n"
		: "=r"(ret)
		);
  return !(ret & 128);
}

IMPLEMENT static inline
void Proc::sti_restore(Status st)
{
  asm volatile ( "    tst    %0, #128    \n"
		 "    bne    1f          \n"
		 "    mrs    r6, cpsr    \n"
		 "    bic    r6,r6,#128  \n"
		 "    msr    cpsr_c, r6  \n"
		 "1:                     \n"
		 : : "r"(st) : "r6"
		 );
}

IMPLEMENT static inline
void Proc::irq_chance()
{
  asm volatile ("nop; nop;" : : : "memory");
}

IMPLEMENTATION[arm-{pxa,sa1100}]:

IMPLEMENT static inline
void Proc::halt()
{
}

IMPLEMENT static inline
void Proc::pause()
{
}

IMPLEMENTATION[arm-926]:


IMPLEMENT static inline
void Proc::pause()
{
  asm volatile("mov     r0, #0 \n\t"
	       "mrc     p15, 0, r1, c1, c0, 0           @ Read control register \n\t"
	       "mcr     p15, 0, r0, c7, c10, 4          @ Drain write buffer    \n\t"
	       "bic     r2, r1, #1 << 12\n\t"
	       "mcr     p15, 0, r2, c1, c0, 0           @ Disable I cache\n\t"
	       "mcr     p15, 0, r0, c7, c0, 4           @ Wait for interrupt\n\t"
	       "mcr     p15, 0, r1, c1, c0, 0           @ Restore ICache enable\n\t"
	       :::"memory",
	       "r0", "r1", "r2", "r3", "r4", "r5",
	       "r6", "r7", "r8", "r9", "r10", "r11",
	       "r12", "r13", "r14", "r15"
      );
}

IMPLEMENT static inline
void Proc::halt()
{
  cli();
  pause();
  sti();
}
