/*
 * IA-32 Kernel-Info Page
 */

INTERFACE [ux]:

#include "vhw.h"

INTERFACE [ia32,ux]:

#include "types.h"

EXTENSION class Kip
{
public:

  /* 00 */
  Unsigned32 magic;
  Unsigned32 version;
  Unsigned8  offset_version_strings;
  Unsigned8  fill0[3];
  Unsigned8  kip_sys_calls;
  Unsigned8  fill1[3];

  /* the following stuff is undocumented; we assume that the kernel
     info page is located at offset 0x1000 into the L4 kernel boot
     image so that these declarations are consistent with section 2.9
     of the L4 Reference Manual */

  /* 10 */
  Mword      init_default_kdebug;
  Mword      default_kdebug_exception;
  Mword      sched_granularity;
  Mword      default_kdebug_end;

  /* 20 */
  Mword      sigma0_sp, sigma0_ip;
  Mem_region sigma0_memory;

  /* 30 */
  Mword      sigma1_sp, sigma1_ip;
  Mem_region sigma1_memory;

  /* 40 */
  Mword      root_sp, root_ip;
  Mem_region root_memory;

  /* 50 */
  Mword      l4_config;
  Mword      reserved2;
  Mword      kdebug_config;
  Mword      kdebug_permission;

  /* 60 */
  Mem_region main_memory;
  Mem_region reserved0;

  /* 70 */
  Mem_region reserved1;
  Mem_region semi_reserved;

  /* 80 */
  Mem_region dedicated[4];

  /* A0 */
  volatile Cpu_time clock;
  volatile Cpu_time switch_time;

  /* B0 */
  Mword frequency_cpu;
  Mword frequency_bus;
  volatile Cpu_time thread_time;

  /* C0 */
  Mword      sys_ipc;
  Mword      sys_id_nearest;
  Mword      sys_fpage_unmap;
  Mword      sys_thread_switch;

  /* D0 */
  Mword      sys_thread_schedule;
  Mword      sys_lthread_ex_regs;
  Mword      sys_task_new;
  Mword      sys_privctrl;

  /* E0 */
  char       version_strings[512];

  /* 2E0 */
  char       sys_calls[256];

  /* 3E0 */
  char       pad[288];

  /* ======================================== */

  /* 0x500,
   *   Here resides the LIPC code. If the offset changes, then application
   *   LIPC binding needs to be adjusted.
   */
  char       lipc_code[256];

  /* 0x600 */
  Vhw_descriptor vhw;
};

// =======================================================================
IMPLEMENTATION [ia32,ux]:

#include "l4_types.h"
#include <cstdio>

IMPLEMENT inline
Address Kip::main_memory_high() const
{
  return main_memory.end;
}

IMPLEMENT
char const *Kip::version_string() const
{
  return reinterpret_cast <char const *> (this) + (offset_version_strings << 4);
}
