/*
 * IA-32 Kernel-Info Page
 */

INTERFACE [amd64]:

#include "types.h"

EXTENSION class Kip
{
public:

  /* 00 */
  Unsigned32 magic;
  Unsigned8  fill0[4];
  Unsigned32 version;
  Unsigned8  fill1[4];
  Unsigned8  offset_version_strings;
  Unsigned8  fill2[7];
  Unsigned8  kip_sys_calls;
  Unsigned8  fill3[7];

  /* the following stuff is undocumented; we assume that the kernel
     info page is located at offset 0x1000 into the L4 kernel boot
     image so that these declarations are consistent with section 2.9
     of the L4 Reference Manual */

  /* 20 */
  Mword      init_default_kdebug;
  Mword      default_kdebug_exception;
  Mword      sched_granularity;
  Mword      default_kdebug_end;

  /* 40 */
  Mword      sigma0_sp, sigma0_ip;
  Mem_region sigma0_memory;

  /* 60 */
  Mword      sigma1_sp, sigma1_ip;
  Mem_region sigma1_memory;
  
  /* 80 */
  Mword      root_sp, root_ip;
  Mem_region root_memory;

  /* A0 */
  Mword      l4_config;
  Mword      reserved2;
  Mword      kdebug_config;
  Mword      kdebug_permission;

  /* C0 */
  Mem_region main_memory;
  Mem_region reserved0;

  /* E0 */
  Mem_region reserved1;
  Mem_region semi_reserved;

  /* 100 */
  Mem_region dedicated[4];

  /* 140 */
  volatile Cpu_time clock;
  Unsigned8  fill4[8];
  volatile Cpu_time switch_time;
  Unsigned8  fill5[8];

  /* 160 */
  Mword      frequency_cpu;
  Mword      frequency_bus;
  volatile Cpu_time thread_time;
  Unsigned8  fill6[8];

  /* 180 */
  Mword      sys_ipc;
  Mword      sys_id_nearest;
  Mword      sys_fpage_unmap;
  Mword      sys_thread_switch;

  /* 1A0 */
  Mword      sys_thread_schedule;
  Mword      sys_lthread_ex_regs;
  Mword      sys_task_new;
  Mword      sys_privctrl;

  /* 1C0 */
  char       version_strings[512];

  /* 3C0 */
  char       sys_calls[256];

  /* 4C0 */
  char       pad[64];

  /* ======================================== */

  /* 0x500,
   *   Here resides the LIPC code. If the offset changes, then application
   *   LIPC binding needs to be adjusted.
   */
  char       lipc_code[256];
};


IMPLEMENTATION [amd64]:

#include "l4_types.h"
#include <cstdio>

IMPLEMENT inline
Address Kip::main_memory_high() const
{ 
  return main_memory.end; 
}

IMPLEMENT
char const *Kip::version_string() const
{
  return reinterpret_cast <char const *> (version_strings);
}
