/**
 *    \file    dice/src/fe/FEResourceProperty.h
 *    \brief    contains the declaration of the class CFEResourceProperty
 *
 *    \date    04/25/2004
 *    \author    Ronald Aigner <ra3@os.inf.tu-dresden.de>
 */
/* Copyright (C) 2001-2003 by
 * Dresden University of Technology, Operating Systems Research Group
 *
 * This file contains free software, you can redistribute it and/or modify
 * it under the terms of the GNU General Public License, Version 2 as
 * published by the Free Software Foundation (see the file COPYING).
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * For different licensing schemes please contact
 * <contact@os.inf.tu-dresden.de>.
 */
#ifndef FERESOURCEPROPERTY_H
#define FERESOURCEPROPERTY_H

#include <fe/FEIdentifier.h>

/**
 *    \class CFEResourceProperty
 *    \ingroup frontend
 *    \brief contains a property of a required resource
 */
class CFEResourceProperty : public CFEIdentifier
{
DECLARE_DYNAMIC(CFEResourceProperty);
public:
    /** creates a resource property object */
    CFEResourceProperty(String *pName, String *pValue);
    virtual ~CFEResourceProperty();

    virtual void Serialize(CFile *pFile);
    virtual String GetValue();
    virtual CObject* Clone();

protected:
    /**    copy constructor
     *    \param src the source to copy from
     */
    CFEResourceProperty(CFEResourceProperty & src);

    /**    \var String m_sValue
     *    \brief the value of the property
     */
    String m_sValue;
};

#endif
