/**
 *    \file    dice/src/be/l4/L4BEResourceRequestFunction.h
 *    \brief    contains the declaration of the class CL4BEResourceRequestFunction
 *
 *    \date    04/25/2004
 *    \author    Ronald Aigner <ra3@os.inf.tu-dresden.de>
 */
/* Copyright (C) 2001-2003 by
 * Dresden University of Technology, Operating Systems Research Group
 *
 * This file contains free software, you can redistribute it and/or modify
 * it under the terms of the GNU General Public License, Version 2 as
 * published by the Free Software Foundation (see the file COPYING).
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * For different licensing schemes please contact
 * <contact@os.inf.tu-dresden.de>.
 */
#ifndef L4BERESOURCEREQUESTFUNCTION_H
#define L4BERESOURCEREQUESTFUNCTION_H

#include <be/BEResourceRequestFunction.h>

/** \class CL4BEResourceRequestFunction
 *    \ingroup backend
 *    \brief repesents L4 specific implementations of the functions
 */
class CL4BEResourceRequestFunction : public CBEResourceRequestFunction
{
DECLARE_DYNAMIC(CL4BEResourceRequestFunction);
public:
    /** creates an object of this class */
    CL4BEResourceRequestFunction();
    virtual ~CL4BEResourceRequestFunction();

    virtual void WriteBody(CBEFile *pFile, CBEContext *pContext);

protected:
    /** copy constructor
     *    \param src the source to copy from
     */
    CL4BEResourceRequestFunction(CL4BEResourceRequestFunction &src);
};

#endif
