/* SPDX-License-Identifier: MIT */
/*
 * Created on: 12.11.2013
 *     Author: Matthias Lange <matthias.lange@kernkonzept.com>
 *             Alexander Warg <alexander.warg@kernkonzept.com>
 */

#include <l4/l4virtio/virtio.h>
#include <l4/l4virtio/l4virtio>

L4_CV int
l4virtio_set_status(l4_cap_idx_t cap, unsigned status) L4_NOTHROW
{
  return L4::Cap<L4virtio::Device>(cap)->set_status(status);
}

L4_CV int
l4virtio_config_queue(l4_cap_idx_t cap, unsigned queue) L4_NOTHROW
{
  return L4::Cap<L4virtio::Device>(cap)->config_queue(queue);
}

L4_CV int
l4virtio_register_ds(l4_cap_idx_t cap, l4_cap_idx_t ds_cap,
                     l4_uint64_t base, l4_umword_t offset,
                     l4_umword_t sz) L4_NOTHROW
{
  L4::Ipc::Cap<L4Re::Dataspace> ds;
  ds = L4::Ipc::Cap<L4Re::Dataspace>::from_ci(ds_cap);
  return L4::Cap<L4virtio::Device>(cap)->register_ds(ds, base, offset, sz);
}

L4_CV int
l4virtio_device_config_ds(l4_cap_idx_t cap, l4_cap_idx_t config_ds,
                          l4_addr_t *ds_offset) L4_NOTHROW
{
  return L4::Cap<L4virtio::Device>(cap)
    ->device_config(L4::Cap<L4Re::Dataspace>(config_ds), ds_offset);
}

L4_CV int
l4virtio_device_notification_irq(l4_cap_idx_t cap, unsigned index,
                                 l4_cap_idx_t irq) L4_NOTHROW
{
  return L4::Cap<L4virtio::Device>(cap)
    ->device_notification_irq(index, L4::Cap<L4::Triggerable>(irq));
}
