-- vi:ft=lua

local hw = Io.system_bus()

Io.hw_add_devices(function()
  -- UART4 HW device
  uart4 = Io.Hw.Device(function()
    compatible = {"arm,pl011","arm,primecell"};
    Property.hid = "Raspberry Pi 4 UART4";
    Resource.reg0 = Io.Res.mmio(0xfe201800 , 0xfe201800 + 0x200 - 1);
    Resource.irq0 = Io.Res.irq(32 + 121, Io.Resource.Irq_type_level_high);
    Resource.io0 = Io.Gpio_resource(hw.GPIO, 8, 9);
  end);
end)
