-- vi:ft=lua

local Hw = Io.Hw
local hw_bus = Io.system_bus()

-- add devices to io's device tree
Io.hw_add_devices(function()

  -- create a new hardware device
  ACT_LED = Hw.Device(function()
    -- Set the 'compatible' IDs for the device
    compatible = {"gpio-led,green", "gpio-led",};

    -- set 'hid' property
    Property.hid = "gpio-led,ACT";

    -- Add a GPIO pin as 'led' resource to the device
    -- ACT LED on Raspberry Pi: original B - Pi 3: GPIO pin 16
    --                                       Pi 4: GPIO pin 42
    Resource.led = Io.Gpio_resource(hw_bus.GPIO, 42, 42);
  end);
end)
