-- vi:ft=lua

local Hw = Io.Hw
local hw_bus = Io.system_bus()

-- add devices to io's device tree
Io.Dt.add_children(hw_bus, function()

  -- create a LED device
  LED = Hw.Device(function()
    -- Set the 'compatible' IDs for this device
    compatible = {"gpio-led,blue", "gpio-led",};

    -- set 'hid' property
    Property.hid = "gpio-led,D1";

    -- Add a GPIO pin as 'bled' resource to the device
    -- on OMAP5432uevm this is the blue user LED D1
    Resource.led = Io.Gpio_resource(hw_bus.GPIO.GPIO5, 25, 25);
  end);
end)
