/*
 * Copyright (C) 2008-2009 Technische Universität Dresden.
 * Copyright (C) 2015, 2017, 2019-2024 Kernkonzept GmbH.
 * Author(s): Adam Lackorzynski <adam@os.inf.tu-dresden.de>
 *
 * License: see LICENSE.spdx (in this directory or the directories above)
 */

#include "platform-arm.h"
#include "support.h"

#include <l4/sys/kip.h>
#include <assert.h>

void Platform_arm::setup_kernel_config_arm_common(l4_kernel_info_t *kip)
{
  kernel_type = l4_kip_kernel_has_feature(kip, "arm:hyp")
                ? EL_Support::EL2 : EL_Support::EL1;
}

