/*
 * Copyright (C) 2010 Technische Universität Dresden.
 * Author(s): Adam Lackorzynski <adam@os.inf.tu-dresden.de>
 *
 * License: see LICENSE.spdx (in this directory or the directories above)
 */

/*!
 * \file   support_kirkwood.cc
 * \brief  Support for the kirkwood platform
 */

#include "support.h"
#include "mmio_16550.h"
#include "platform-arm.h"

namespace {
class Platform_arm_kirkwood : public Platform_single_region_ram<Platform_arm>
{
  bool probe() override { return true; }

  void init() override
  {
    kuart.base_address = 0xf1012000; /* uart 1: 0xf1012100 */
    kuart.reg_shift    = 2;
    kuart.base_baud    = 12500000;
    kuart.baud         = 115200;
    kuart.irqno        = 33;         /* uart 1 irq: ??? */
    kuart.access_type  = L4_kernel_options::Uart_type_mmio;
    kuart_flags       |=   L4_kernel_options::F_uart_base
                         | L4_kernel_options::F_uart_baud
                         | L4_kernel_options::F_uart_irq;
    static L4::Uart_16550 _uart(kuart.base_baud, 0, 0, 0, 0);
    setup_16550_mmio_uart(&_uart);


    // SPI init, as there's an interrupt pending when coming from u-boot on
    // the dockstar, so make it go away
    *(unsigned *)0xf1010600 = 0; // disable
    *(unsigned *)0xf1010614 = 0; // mask interrupt
    *(unsigned *)0xf1010610 = 1; // clear interrupt
  }
};
}

REGISTER_PLATFORM(Platform_arm_kirkwood);
