
define SRC_libc/sysdeps/linux
  setjmp
  bsd-setjmp
  bsd-_setjmp
  creat
  longjmp
  __longjmp
  getdents
  getsid
  common/gethostname
  common/getdirname
  common/getpagesize
endef

define SRC_libc/sysdeps/linux_large_file
  creat64
endef

SRC_libc/sysdeps/linux_arm += aeabi_atexit
SRC_libc/sysdeps/linux_arm += find_exidx

SRC_libc/sysdeps/linux_mips += setjmp_aux
SRC_libc/sysdeps/linux_mips += _test_and_set

define SRC_libc/sysdeps/linux_sparc__with_soft_fp
  soft-fp/q_add
  soft-fp/q_cmp
  soft-fp/q_cmpe
  soft-fp/q_div
  soft-fp/q_dtoq
  soft-fp/q_feq
  soft-fp/q_fge
  soft-fp/q_fgt
  soft-fp/q_fle
  soft-fp/q_flt
  soft-fp/q_fne
  soft-fp/q_itoq
  soft-fp/q_lltoq
  soft-fp/q_mul
  soft-fp/q_neg
  soft-fp/q_qtod
  soft-fp/q_qtoi
  soft-fp/q_qtoll
  soft-fp/q_qtos
  soft-fp/q_qtou
  soft-fp/q_qtoull
  soft-fp/q_sqrt
  soft-fp/q_stoq
  soft-fp/q_sub
  soft-fp/q_ulltoq
  soft-fp/q_util
  soft-fp/q_utoq
endef

ifeq ($(GCCIS_sparc_leon),)
  define SRC_libc/sysdeps/linux_sparc
    udiv
    umul
    urem
  endef
  SRC_libc/sysdeps/linux_sparc += $(SRC_libc/sysdeps/linux_sparc__with_soft_fp)
endif

define SRC_libc/termios
  isatty
  speed
  tcflush
  tcgetattr
  tcgetpgrp
  tcgetsid
  tcsetattr
  tcsetpgrp
  ttyname
endef

define SRC_libc/stdlib
  __cxa_atexit
  __exit_handler
  __strtofpmax
  __uc_malloc
  _stdlib_strto_l
  _stdlib_strto_ll
  abort
  abs
  atoi
  atol
  atoll
  bsearch
  div
  exit
  gcvt
  getenv
  jrand48
  jrand48_r
  labs
  ldiv
  llabs
  lldiv
  lrand48
  lrand48_r
  mkostemp
  mkstemp
  mkstemp64
  nrand48
  nrand48_r
  on_exit
  posix_memalign
  qsort
  qsort_r
  rand
  rand_r
  random
  random_r
  realpath
  setenv
  srand48
  srand48_r
  stdlib
  strtol
  strtoll
  strtoul
  strtoull
endef

define SRC_libc/stdlib_large_file
  mkostemp64
endef

define SRC_libc/stdlib_fp
  __fp_range_check
  _strtod
  atof
  drand48-iter
  drand48
  drand48_r
  erand48
  erand48_r
  strtod
  strtof
  strtold
endef

define SRC_libc/stdlib/malloc-standard
  calloc
  free
  mallinfo
  malloc
  mallopt
  memalign
  realloc
endef

define SRC_libc/stdlib/malloc-simple
  alloc
  calloc
  free
  malloc
  memalign
  realloc
endef

define SRC_libc/stdlib_wchar
  _stdlib_mb_cur_max
  wcstombs
  mblen
  mbstowcs
endef

define SRC_libc/string
  basename
  dirname
  ffs
  memccpy
  stpcpy
  stpncpy
  strcasecmp
  strcasestr
  strdup
  strerror
  __xpg_strerror_r
  _string_syserrmsgs
  __glibc_strerror_r
  _string_syssigmsgs
  sys_siglist
  strsignal
  psignal
  __xpg_basename
  strlcat
  strlcpy
  sys_errlist
  strndup
  strncasecmp
  strtok
  bcopy
  bzero
  memchr
  memcpy
  memmove
  memset
  strcat
  strchr
  strcmp
  strcpy
  strlen
  strncat
  strncmp
  strncpy
  strnlen
  strrchr
  memcmp
  memmem
  mempcpy
  memrchr
  rawmemchr
  strchrnul
  strcspn
  strsep
  strspn
  strstr
  strtok_r
  strpbrk
endef

define SRC_libc/string_wchar
  wcscmp
  wcsnlen
  wcslen
  wcsncpy
  wmemcpy
  wcsstr
  wcscasecmp
  wcscpy
  wcsncasecmp
  wcstok
  wcscat
  wcscspn
  wcspbrk
  wcschr
  wcsdup
  wcsncat
  wcsrchr
  wcsxfrm
  wcschrnul
  wcslcpy
  wcsncmp
  wcsspn
  wmemchr
  wmemcmp
  wmemmove
  wmemset
endef

SRC_libc/string_arm := _memcpy

define SRC_libc/misc
  assert/__assert
  ctype/ctype
  ctype/isalnum
  ctype/isalpha
  ctype/isascii
  ctype/isblank
  ctype/iscntrl
  ctype/isdigit
  ctype/isgraph
  ctype/islower
  ctype/isprint
  ctype/ispunct
  ctype/isspace
  ctype/isupper
  ctype/isxdigit
  ctype/tolower
  ctype/toupper
  ctype/__C_ctype_b
  ctype/__C_ctype_tolower
  ctype/__C_ctype_toupper
  ctype/__ctype_b_loc
  ctype/__ctype_tolower_loc
  ctype/__ctype_toupper_loc
  ctype/__ctype_assert
  ctype/isctype
  dirent/alphasort
  dirent/closedir
  dirent/dirfd
  dirent/opendir
  dirent/readdir
  dirent/readdir_r
  dirent/rewinddir
  dirent/scandir
  dirent/seekdir
  dirent/telldir
  error/err
  fnmatch/fnmatch
  glob/glob
  internals/errno
  internals/h_errno
  internals/__errno_location
  internals/__h_errno_location
  internals/__uClibc_main
  internals/parse_config
  internals/tempname
  locale/locale
  locale/localeconv
  locale/nl_langinfo
  locale/setlocale
  regex/regex_old
  search/hcreate_r
  search/hdestroy_r
  search/hsearch
  search/hsearch_r
  search/insque
  search/insremque
  search/lfind
  search/lsearch
  search/remque
  search/tdelete
  search/tdestroy
  search/tfind
  search/tsearch
  search/twalk
  time/time
  time/asctime
  time/asctime_r
  time/ctime
  time/ctime_r
  time/ftime
  time/gmtime
  time/gmtime_r
  time/localtime
  time/localtime_r
  time/mktime
  time/strftime
  time/strptime
  time/tzset
  time/_time_t2tm
  time/__time_tm
  time/_time_mktime
  time/dysize
  time/timegm
  time/_time_mktime_tzi
  time/_time_localtime_tzi
  wordexp/wordexp
  elf/dl-iterate-phdr
endef

define SRC_libc/misc_fp
  time/difftime
endef

define SRC_libc/misc_large_file
  dirent/alphasort64
  dirent/readdir64
  dirent/readdir64_r
  dirent/scandir64
  glob/glob64
endef

define SRC_libc/misc_libuc_c.a
  elf/dl-support
  elf/dl-core
endef

SRC_libc/misc_libuc_c_minimal.a = $(SRC_libc/misc_libuc_c.a)

define SRC_libc/misc_wchar
  time/wcsftime
  wchar/btowc
  wchar/mbrlen
  wchar/mbrtowc
  wchar/mbsnrtowcs
  wchar/mbsrtowcs
  wchar/wchar
  wchar/wctob
  wchar/wcrtomb
  wchar/wcsnrtombs
  wchar/wcsrtombs
  wctype/iswctype
  wctype/wctype
  wctype/_wctype
  wctype/towlower
  wctype/towupper
  wctype/towctrans
  wctype/wctrans
  wctype/iswxdigit
  wctype/iswupper
  wctype/iswlower
  wctype/iswspace
  wctype/iswpunct
  wctype/iswprint
  wctype/iswgraph
  wctype/iswdigit
  wctype/iswcntrl
  wctype/iswblank
  wctype/iswalpha
  wctype/iswalnum
endef

define SRC_libc/stdio
  __fsetlocking
  _adjust_pos
  _cs_funcs
  _fopen
  _fpmaxtostr
  _fwrite
  _READ
  _WRITE
  _load_inttype
  _rfill
  _stdio
  _store_inttype
  _trans2r
  _trans2w
  _uintmaxtostr
  _wcommit
  asprintf
  clearerr
  clearerr.__DO_UNLOCKED
  dprintf
  fclose
  fcloseall
  fdopen
  feof
  feof.__DO_UNLOCKED
  ferror
  ferror.__DO_UNLOCKED
  fflush
  fflush.__DO_UNLOCKED
  fgetc
  fgetc.__DO_UNLOCKED
  fgetpos
  fgets
  fgets.__DO_UNLOCKED
  fileno
  fileno.__DO_UNLOCKED
  flockfile
  fopen
  freopen
  fputs
  fputs.__DO_UNLOCKED
  fputc
  fputc.__DO_UNLOCKED
  fprintf
  fread
  fread.__DO_UNLOCKED
  fseeko
  fsetpos
  ftello
  funlockfile
  fwrite
  fwrite.__DO_UNLOCKED
  getchar
  getdelim
  getline
  perror
  printf
  putchar
  putchar.__DO_UNLOCKED
  puts
  remove
  rewind
  _scanf
  vfscanf
  __scan_cookie
  __psfs_parse_spec
  __psfs_do_numeric
  scanf
  sscanf
  fscanf
  vscanf
  vsscanf
  setvbuf
  setbuf
  setbuffer
  setlinebuf
  snprintf
  sprintf
  tmpfile
  ungetc
  vasprintf
  vdprintf
  _vfprintf
  _vfprintf_internal
  vfprintf
  _ppfs_init
  _ppfs_prepargs
  _ppfs_setargs
  _ppfs_parsespec
  vsnprintf
  vsprintf
  vprintf
endef

define SRC_libc/stdio_large_file
  fgetpos64
  fopen64
  freopen64
  fseeko64
  fsetpos64
  ftello64
endef

define SRC_libc/stdio_wchar
  _wfwrite
  fputwc
  fputwc.__DO_UNLOCKED
  fgetwc
  fgetwc.__DO_UNLOCKED
  fputws
  fputws.__DO_UNLOCKED
  fwprintf
  ungetwc
  swprintf
  _vfwprintf_internal
  vfwprintf
  vswprintf
  vwprintf
  wprintf
endef

define SRC_libc/inet
  _res_state
  addr
  closenameservers
  decodea
  decoded
  decodeh
  decodep
  decodeq
  dnslookup
  encodea
  encoded
  encodeh
  encodep
  encodeq
  ether_addr
  formquery
  gai_strerror
  get_hosts_byaddr_r
  get_hosts_byname_r
  getaddrinfo
  gethostbyaddr
  gethostbyaddr_r
  gethostbyname
  gethostbyname2
  gethostbyname2_r
  gethostbyname_r
  gethostent
  gethostent_r
  getnet
  getproto
  getservice
  herror
  if_index
  inet_addr
  inet_aton
  inet_lnaof
  inet_makeaddr
  inet_net
  inet_netof
  inet_ntoa
  in6_addr
  lengthd
  lengthq
  ns_name
  ntohl
  ntop
  opennameservers
  opensock
  read_etc_hosts_r
  res_comp
  res_init
  res_query
  resolv
endef

define SRC_libc/pwd_grp
  pwd_grp
  getgrgid
  getgrgid_r
  getgrnam
  getgrnam_r
  getpwuid
  getpwuid_r
  getpwnam
  getpwnam_r
  getpwent
  getpwent_r
  __parsepwent
  __parsegrent
  __pgsreader
endef

define SRC_libc/unistd
  getlogin
  getopt
  sleep
endef

define SRC_libc/signal
  allocrtsig
  raise
  sigaddset
  sigandset
  sigdelset
  sigempty
  sigfillset
  sigismem
  sigsetops
  sigjmp
endef

define SRC_libcrypt
  crypt
  des
  md5
endef

define SRC_libm
  carg
  cexp
  e_acos
  e_acosh
  e_asin
  e_atan2
  e_atanh
  e_cosh
  e_exp
  e_fmod
  e_hypot
  e_j0
  e_j1
  e_jn
  e_lgamma_r
  e_log
  e_log10
  e_log2
  e_pow
  e_remainder
  e_rem_pio2
  e_scalb
  e_sinh
  e_sqrt
  k_cos
  k_rem_pio2
  k_sin
  k_standard
  k_tan
  s_asinh
  s_atan
  s_cbrt
  s_ceil
  s_copysign
  s_cos
  s_erf
  s_expm1
  s_fabs
  s_fpclassify
  s_fdim
  s_finite
  s_finitef
  s_floor
  s_fma
  s_fmax
  s_fmin
  s_frexp
  s_ilogb
  s_isnan
  s_isnanf
  s_isinf
  s_isinff
  s_ldexp
  s_lib_version
  s_llrint
  s_llround
  s_log1p
  s_logb
  s_lrint
  s_lround
  s_matherr
  s_modf
  s_nextafter
  s_nextafterf
  s_remquo
  s_rint
  s_round
  s_scalbn
  s_signbit
  s_signbitf
  s_signgam
  s_significand
  s_sin
  s_tan
  s_tanh
  s_trunc
  w_cabs
  w_exp2
  nan
endef

SRC_libm_float_src = float_wrappers.c
define SRC_libm_float
  acos
  acosf
  acoshf
  asinf
  asinhf
  atan2f
  atanf
  atanhf
  cbrtf
  ceilf
  copysignf
  cosf
  coshf
  erfcf
  erff
  exp2f
  expf
  expm1f
  fabsf
  fdimf
  floorf
  fmaf
  fmaxf
  fminf
  fmodf
  frexpf
  hypotf
  ilogbf
  ldexpf
  lgammaf
  llrintf
  log10f
  log1pf
  log2f
  logbf
  logf
  lrintf
  lroundf
  modff
  nearbyintf
  nextafterf
  powf
  remainderf
  remquof
  rintf
  roundf
  scalblnf
  scalbnf
  sinf
  sinhf
  sqrtf
  tanf
  tanhf
  tgammaf
  truncf
endef

SRC_libm_double_src = ldouble_wrappers.c
define SRC_libm_double
  acoshl
  acosl
  asinhl
  asinl
  atan2l
  atanhl
  atanl
  cargl
  cbrtl
  ceill
  copysignl
  coshl
  cosl
  erfcl
  erfl
  expl
  expm1l
  fabsl
  fdiml
  floorl
  fmal
  fmaxl
  fminl
  fmodl
  frexpl
  gammal
  hypotl
  ilogbl
  ldexpl
  lgammal
  llrintl
  llroundl
  log10l
  log1pl
  log2l
  logbl
  logl
  lrintl
  lroundl
  modfl
  nearbyintl
  nextafterl
  powl
  remainderl
  remquol
  rintl
  roundl
  scalblnl
  scalbnl
  sinhl
  sinl
  sqrtl
  tanhl
  tanl
  tgammal
  truncl
  significandl
endef
